<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2014 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/
	define('NEW_MACHFORM_VERSION', '4.2');

	require('includes/init.php');

	require('config.php');
	require('includes/db-core.php');
	require('lib/password-hash.php');
	require('includes/setup-functions.php');

	//1. Check PHP version
	if(version_compare(PHP_VERSION,"5.2.0",">=")){
		$is_php_version_passed = true;
	}else{
		$is_php_version_passed = false;
		$pre_install_error = 'php_version_insufficient';
	}

	if($is_php_version_passed){
		//2. Check connection to Database
		try {
			  $dbh = new PDO('mysql:host='.MF_DB_HOST.';dbname='.MF_DB_NAME, MF_DB_USER, MF_DB_PASSWORD,
			  				 array(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true)
			  				 );
			  $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			  $dbh->query("SET NAMES utf8");
		} catch(PDOException $e) {
			  $error_connecting =  "خطا در اتصال به پایگاه داده:".$e->getMessage();
			  $pre_install_error = $error_connecting;
		}

		//3. Check MySQL version
		$params = array();
		if(empty($error_connecting)){
			$query = "select version() mysql_version_number";
			$sth = $dbh->prepare($query);
			try{
				$sth->execute($params);
			}catch(PDOException $e) {
				echo "بررسی کنید نوع خطای مواجه شده را: ".$e->getMessage();
			}
			
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			$current_mysql_version = $row['mysql_version_number'];

			if(version_compare($current_mysql_version,"4.1.0","<")){
				$error_mysql_version = "نسخه خروجی زیر فعلی شما ({$current_mysql_version}) کمتر از حداقل مورد نیاز است (4.1.0)";
				$pre_install_error = $error_mysql_version;
			}

			//4. Check for existing MachForm installation
			if(empty($error_mysql_version)){
				$is_machform_installed = true;

				try{
					$query = "select count(*) from ".MF_TABLE_PREFIX."forms";
					$sth = $dbh->prepare($query);
					
					$sth->execute($params);
				}catch(PDOException $e) {
					$is_machform_installed = false;
				}

				if($is_machform_installed){
					$pre_install_error = 'machform_already_installed';
				}else{
					//5. Check the "data" folder
					if(!is_writable('./data')){
						$pre_install_error = 'data_dir_unwritable';
					}
				}
			}
		}
	}

	if(empty($pre_install_error) && !empty($_POST['run_install'])){

		$admin_username = trim($_POST['admin_username']);
		$license_key = trim($_POST['license_key']);
		
		//do the installation here
		//check the email address first
		$email_regex  = '/^[A-z0-9][\w.\'-]*@[A-z0-9][\w\-\.]*\.[A-z0-9]{2,}$/';
		$regex_result = preg_match($email_regex, $admin_username);
			
		if(empty($regex_result) || empty($admin_username)){
			$is_invalid_admin_email = true;
		}else{
			$is_invalid_admin_email = false;
		}

		//check license key
		if(empty($license_key)){
			$is_invalid_license_key = false;
		}else{
			$v_final_key = str_replace('-', '', $license_key);
			$v_key_hash  = substr($v_final_key, -4);
			$v_license_seed_hash = md5(substr($v_final_key,0,16));
			$v_license_seed_hash_4 = strtoupper(substr($v_license_seed_hash, -4));

			if($v_license_seed_hash_4 == $v_key_hash){
				$is_invalid_license_key = false;
			}else{
				$is_invalid_license_key = false;
			}

		}

		if(!$is_invalid_admin_email && !$is_invalid_license_key){
			//do installation tasks here
			$post_install_error = '';

			//1. Create ap_forms table
			$post_install_error .= create_ap_forms_table($dbh);

			//2. Create ap_column_preferences table
			$post_install_error .= create_ap_column_preferences_table($dbh);

			//3. Create ap_element_options table
			$post_install_error .= create_ap_element_options_table($dbh);

			//4. Create ap_element_prices table
			$post_install_error .= create_ap_element_prices_table($dbh);

			//5. Create ap_form_elements table
			$post_install_error .= create_ap_form_elements_table($dbh);
			
			//6. Create ap_form_filters table
			$post_install_error .= create_ap_form_filters_table($dbh);

			//7. Create ap_form_themes table
			$post_install_error .= create_ap_form_themes_table($dbh);

			//8. Insert into ap_form_themes table
			$post_install_error .= populate_ap_form_themes_table($dbh);
			
			//9. Create ap_fonts table
			$post_install_error .= create_ap_fonts_table($dbh);

			//10. Insert into ap_fonts table
			$post_install_error .= populate_ap_fonts_table($dbh);			

			
			//11. Create ap_settings table
			$post_install_error .= create_ap_settings_table($dbh);

			//12. Insert into ap_settings table
			$domain = str_replace('www.','',$_SERVER['SERVER_NAME']);
			$default_from_email = "no-reply@{$domain}";

			if(!empty($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] != 'off')){
				$ssl_suffix = 's';
			}else if(isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https'){
			    $ssl_suffix = 's';
			}else if (isset($_SERVER['HTTP_FRONT_END_HTTPS']) && $_SERVER['HTTP_FRONT_END_HTTPS'] == 'on'){
			    $ssl_suffix = 's';
			}else{
				$ssl_suffix = '';
			}
			
			$machform_base_url = 'http'.$ssl_suffix.'://'.$_SERVER['HTTP_HOST'].rtrim(dirname($_SERVER['PHP_SELF']), '/\\').'/';

			$options = array();

			$options['default_from_email'] 	 = $default_from_email;
			$options['machform_base_url']  	 = $machform_base_url;
			$options['new_machform_version'] = NEW_MACHFORM_VERSION;
			$options['license_key'] 		 = $license_key;

			$post_install_error .= populate_ap_settings_table($dbh,$options);

			//13. Create ap_users table
			$post_install_error .= create_ap_users_table($dbh);

			//14. Insert into ap_users table
			$hasher = new PasswordHash(8, FALSE);
			$default_password_hash = $hasher->HashPassword('machform');

			$options = array();
			
			$options['admin_username'] = $admin_username;
			$options['default_password_hash'] = $default_password_hash;

			$post_install_error .= populate_ap_users_table($dbh,$options);

			//15. Create ap_permissions table
			$post_install_error .= create_ap_permissions_table($dbh);

			//16. Create ap_entries_preferences table
			$post_install_error .= create_ap_entries_preferences_table($dbh);

			//17. Create ap_form_locks table
			$post_install_error .= create_ap_form_locks_table($dbh);

			//18. Create ap_form_sorts table
			$post_install_error .= create_ap_form_sorts_table($dbh);
			
			//19. Create ap_field_logic_elements table
			$post_install_error .= create_ap_field_logic_elements_table($dbh);

			//20. Create ap_field_logic_conditions table
			$post_install_error .= create_ap_field_logic_conditions_table($dbh);

			//21. Create ap_form_payments table
			$post_install_error .= create_ap_form_payments_table($dbh);

			//22. Create ap_page_logic table
			$post_install_error .= create_ap_page_logic_table($dbh);

			//22. Create ap_page_logic_conditions table
			$post_install_error .= create_ap_page_logic_conditions_table($dbh);

			//23. Create ap_email_logic table
			$post_install_error .= create_ap_email_logic_table($dbh);

			//24. Create ap_email_logic_conditions table
			$post_install_error .= create_ap_email_logic_conditions_table($dbh);

			//25. Create ap_webhook_options table
			$post_install_error .= create_ap_webhook_options_table($dbh);

			//26. Create ap_webhook_parameters table
			$post_install_error .= create_ap_webhook_parameters_table($dbh);

			//27. Create ap_webhook_logic_conditions table
			$post_install_error .= create_ap_webhook_logic_conditions_table($dbh);

			//28. Create ap_reports table
			$post_install_error .= create_ap_reports_table($dbh);

			//29. Create ap_report_elements table
			$post_install_error .= create_ap_report_elements_table($dbh);

			//30. Create ap_report_filters table
			$post_install_error .= create_ap_report_filters_table($dbh);

			//31. Create ap_grid_columns table
			$post_install_error .= create_ap_grid_columns_table($dbh);

			//check for errors ------------------------
			if(empty($post_install_error)){
				$installation_success = true;
			}else{
				$installation_has_error = true;
			}

			//Create "themes" folder
			if(is_writable("./data") && $installation_success){
				$old_mask = umask(0);
				mkdir("./data/themes",0777);
				umask($old_mask);
			}
			
		}
	}

	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>نصب فرمساز</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="robots" content="index, nofollow" />
<link rel="stylesheet" type="text/css" href="css/main.css" media="screen" />   
    
<!--[if IE 7]>
	<link rel="stylesheet" type="text/css" href="css/ie7.css" media="screen" />
<![endif]-->
	
<!--[if IE 8]>
	<link rel="stylesheet" type="text/css" href="css/ie8.css" media="screen" />
<![endif]-->

<!--[if IE 9]>
	<link rel="stylesheet" type="text/css" href="css/ie9.css" media="screen" />
<![endif]-->
   
<link href="css/theme.css" rel="stylesheet" type="text/css" />
<link href="css/bb_buttons.css" rel="stylesheet" type="text/css" />
<link type="text/css" href="js/jquery-ui/themes/base/jquery.ui.all.css" rel="stylesheet" />
<link type="text/css" href="css/edit_form.css" rel="stylesheet" />
<link type="text/css" href="js/datepick/smoothness.datepick.css" rel="stylesheet" />
<link href="css/override.css" rel="stylesheet" type="text/css" />
</head>

<body>

<div id="bg" class="installer_page">

<div id="container">

	<div id="header">
	
		<div id="logo">
			<img class="title" src="images/machform_logo.png" style="margin-left: 8px" alt="MachForm" />
		</div>	

		
		<div class="clear"></div>
		
	</div>
	<div id="main">
	
 
		<div id="content">
			<div class="post installer">

				<div style="padding-top: 10px">
					
					<?php if(empty($pre_install_error)){ ?>

					<?php 	if($installation_success){ ?>
								<div>
									<img src="images/icons/62_green_48.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>موفقیت آمیز!</h3>
									<p>عملیات نصب با موفقیت انجام گرفت.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="index.php">
										<ul>
											<li>
												<p>در قسمت زیر اطلاعات ورود شما میباشد:</p>
												<p style="margin-top: 10px; margin-bottom: 20px">ایمیل: <b><?php echo htmlspecialchars($admin_username); ?></b><br/>
												   کلمه عبور: <b>machform</b></p>
												<p>لطفا بعد از اینکه وارد پنل خود شدید رمز عبور خود را تغییر دهید!</a>
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left;border-radius: 4px">
											        <span class="icon-keyhole"></span>
											        ورود به پنل فرم ساز
											    </button>
											</li>
										</ul>
									</form>
								</div>	
					<?php	}else if($installation_has_error){ //if server meet the requirements but error during install (error while creating tables) ?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا در نصب و راه اندازی!</h3>
									<p>لطفا خطای زیر را اصلاح کنید و دوباره سعی کنید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5><?php echo $post_install_error; ?></h5>	
											</li>
											<li>
												لطفا اطمینان حاصل کنید که کاربر پایگاه داده در دسترس بوده و بتوان در آن جداول را ایجاد کرد
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left;border-radius: 4px">
											        <span class="icon-checkmark"></span>
											        دوباره تلاش کنید
											    </button>
											</li>
										</ul>
									</form>
								</div>
					<?php   }else{ ?>
								<div>
									<img src="images/icons/advancedsettings.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>فرمساز آماده نصب میباشد</h3>
									<p>لطفا فرم زیر را پر کنید و بر روی دکمه نصب کلیک کنید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">
										<ul>
											<?php if($is_invalid_admin_email){ ?>
												<li id="li_installer_notification">
													<h5>خطا! لطفا آدرس ایمیل معتبر وارد کنید!</h5>
												</li>
			
											<?php } ?>

											<li id="li_email_address" style="margin-top: 25px;">		
												<label class="desc" for="admin_username">آدرس ایمیل شما</label>
												<div>
													<input id="admin_username" name="admin_username" class="element text large" type="text" maxlength="255" value="<?php echo htmlspecialchars($admin_username); ?>"/>
													<span style="font-size: 85%;color: #444444">شما از این استفاده کنید برای ورود به پنل.</span> 
												</div>
											</li>		
								    		<li id="li_submit" class="buttons" style="overflow: auto">
								    			<input type="hidden" name="run_install" id="run_install" value="1">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left;border-radius: 4px">
											        <span class="icon-checkmark"></span>
											        نصب فرمساز
											    </button>
											</li>
										</ul>
									</form>
								</div>	

					<?php   }
								
						
						 }else{ //else if there are pre install error 
							if($pre_install_error == 'php_version_insufficient' || $pre_install_error == 'data_dir_unwritable'){
								if($pre_install_error == 'php_version_insufficient'){
									$pre_install_error = "Your current PHP version (".PHP_VERSION.") is less than the minimum requirement (5.2.0)";
								}else{
									$pre_install_error = " <strong><u>داده های</u></strong> فایل های درون فایل فرمساز قابل نوشتن نیستند. لطفاً قرار دهید  دسترسی و قابلیت نوشتن را بر روی (CHMOD 777)";
								}
					?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا! قادر به نصب نیست</h3>
									<p>خطا را اصلاح کنید و از زیر ادامه دهید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5><?php echo $pre_install_error; ?></h5>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left;border-radius: 4px">
											        <span class="icon-checkmark"></span> 
											        دوباره چک کنید
											    </button>
											</li>
										</ul>
									</form>
								</div>	
					<?php	}else if($pre_install_error == 'machform_already_installed'){
					?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>فرمساز قبلا نصب شده</h3>
									<p>لطفا برای ورود به پنل از زیر وارد شوید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="index.php">
										<ul>
											<li id="li_installer_notification">
												<h5>فرمساز شما قبلا نصب شده و آماده میباشد.</h5><h5>شما می توانید به پنل مدیریت وارد شوید برای ایجاد / ویرایش فرمهایتان.</h5>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left;border-radius: 4px">
											        <span class="icon-keyhole"></span>
											        ورود به فرمساز
											    </button>
											</li>
										</ul>
									</form>
								</div>	

					<?php		
							}else{ //error connecting to database
					?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطای اتصال به پایگاه داده</h3>
									<p>لطفا خطا را اصلاح کنید و از زیر ادامه دهید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5><?php echo $pre_install_error; ?></h5>
											</li>
											<li style="font-family: Arial, Helvetica, sans-serif">
												<p>چند چیز برای رفع این مشکل وجود دارد:
													<ul style="list-style-type:disc;">
														<li style="margin-left: 20px;padding-left: 0px;padding-bottom: 0px">اطمینان حاصل کنید که شما پایگاه داده و نام کاربری و رمز عبور آن را درست کرده اید</li>
														<li style="margin-left: 20px;padding-left: 0px">اطمینان حاصل کنید که نام پایگاه داده را درست وارد کرده اید</li>
													</ul>
												</p>
												<p style="margin-top: 15px">اگر مشکلی بود با ما تماس بگیرید ، خوشحال میشویم که بتوانیم کمکتان کنیم : 09368510305!</p>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left;border-radius: 4px">
											        <span class="icon-checkmark"></span>
											        دوباره چک کنید
											    </button>
											</li>
										</ul>
									</form>
								</div>	


					<?php	}	
 						  } //end - else if there are pre install error
					?>
					
					
				</div>
     
        	</div>  		 
		</div>
	
		

<?php
	$footer_data =<<<EOT
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.core.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.widget.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.tabs.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.mouse.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.sortable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.draggable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.position.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.dialog.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.effects.core.js"></script>
EOT;
	require('includes/footer.php'); 
?>