<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2014 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/
	require('includes/init.php');

	require('config.php');
	require('includes/language.php');
	require('includes/db-core.php');
	require('lib/password-hash.php');
	require('lib/dbbackup.class.php');
	require('includes/helper-functions.php');
	require('includes/theme-functions.php');
	require('includes/setup-functions.php');

	define('NEW_MACHFORM_VERSION', '4.2');
	define('SKIP_DB_BACKUP',false);	 //change this to true if you need to skip the database backup during upgrade

	//1. Check PHP version
	if(version_compare(PHP_VERSION,"5.2.0",">=")){
		$is_php_version_passed = true;
	}else{
		$is_php_version_passed = false;
		$pre_install_error = 'php_version_insufficient';
	}

	if($is_php_version_passed){
		$quick_upgrade = false;

		//2. Check connection to Database
		try {
			  $dbh = new PDO('mysql:host='.MF_DB_HOST.';dbname='.MF_DB_NAME, MF_DB_USER, MF_DB_PASSWORD,
			  				 array(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true)
			  				 );
			  $dbh->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
			  $dbh->query("SET NAMES utf8");
		} catch(PDOException $e) {
			  $error_connecting =  "خطا در اتصال به پایگاه داده: ".$e->getMessage();
			  $pre_install_error = $error_connecting;
		}

		//3. Check MySQL version
		$params = array();
		if(empty($error_connecting)){
			
			try{
				$query = "select version() mysql_version_number";
				$sth = $dbh->prepare($query);

				$sth->execute($params);
			}catch(PDOException $e) {
				echo "نسخه شکست خورده را بررسی کنید: ".$e->getMessage();
			}
			
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			$current_mysql_version = $row['mysql_version_number'];

			if(version_compare($current_mysql_version,"4.1.0","<")){
				$error_mysql_version = "نسخه MySQL فعلی شما ({$current_mysql_version}) کمتر از حداقل مورد نیاز است (4.1.0)";
				$pre_install_error = $error_mysql_version;
			}

			//4. Check for existing MachForm installation
			if(empty($error_mysql_version)){

				//check if any version of machform exist or not
				$is_machform_db_exist = true;

				try{
					$query = "select count(*) from ".MF_TABLE_PREFIX."forms";
					$sth = $dbh->prepare($query);

					$sth->execute($params);
				}catch(PDOException $e) {
					$is_machform_db_exist = false;
				}

				if(!$is_machform_db_exist){ //if there is no previous machform installation
					$pre_install_error = 'machform_db_not_exist';
				}else{
					//machform was installed
					//we need to make sure the current version
					$current_machform_version = '1';
					
					try{
						$query = "select count(*) from ".MF_TABLE_PREFIX."column_preferences";
						$sth = $dbh->prepare($query);
						
						$sth->execute($params);
						$current_machform_version = '2';
					}catch(PDOException $e) {
						//do nothing, continue
					}

					try{
						$query = "select count(*) from ".MF_TABLE_PREFIX."fonts";
						$sth = $dbh->prepare($query);

						$sth->execute($params);
						$current_machform_version = '3';
					}catch(PDOException $e) {
						//do nothing, continue
					}

					if($current_machform_version === '1'){
						$pre_install_error = 'version1_incompatible';
					}else if($current_machform_version === '3'){
						//check further version number
						$mf_settings = mf_get_settings($dbh);

						if(NEW_MACHFORM_VERSION === $mf_settings['machform_version']){
							$pre_install_error = 'machform_already_installed';
						}else{
							$quick_upgrade = true;
							$current_machform_version = $mf_settings['machform_version'];
							//check the data folder
							if(!is_writable($mf_settings['data_dir'])){
								$pre_install_error = 'data_dir_unwritable';
							}
						}
					}else if($current_machform_version === '2'){
						//this is machform 2
						//we can continue with the upgrade
						//check the data folder
						if(!is_writable('./data')){
							$pre_install_error = 'data_dir_unwritable';
						}
					}

				}

			}
		}
	}

	if(empty($pre_install_error) && !empty($_POST['run_upgrade'])){

		if($quick_upgrade === false){
			$admin_username = trim($_POST['admin_username']);
			$license_key = trim($_POST['license_key']);
			//do the installation here
			//check the email address first
			
			$email_regex  = '/^[A-z0-9][\w.-]*@[A-z0-9][\w\-\.]*\.[A-z0-9]{2,6}$/';
			$regex_result = preg_match($email_regex, $admin_username);
				
			if(empty($regex_result) || empty($admin_username)){
				$is_invalid_admin_email = true;
			}else{
				$is_invalid_admin_email = false;
			}

			//check license key
			if(empty($license_key)){
				$is_invalid_license_key = true;
			}else{
				$v_final_key = str_replace('-', '', $license_key);
				$v_key_hash  = substr($v_final_key, -4);
				$v_license_seed_hash = md5(substr($v_final_key,0,16));
				$v_license_seed_hash_4 = strtoupper(substr($v_license_seed_hash, -4));

				if($v_license_seed_hash_4 == $v_key_hash){
					$is_invalid_license_key = false;
				}else{
					$is_invalid_license_key = true;
				}
			}
		}else{
			$is_invalid_license_key = false;
			$is_invalid_admin_email = false;
		}

		if(!$is_invalid_admin_email && !$is_invalid_license_key){
			//do upgrade tasks here
			$post_install_error = '';

			if($current_machform_version === '2'){
				//if we're upgrading from v2.x
				$options = array();
				$options['license_key'] 		 = $license_key;
				$options['new_machform_version'] = NEW_MACHFORM_VERSION;
				$options['admin_username']		 = $admin_username;
				$post_install_error .= do_delta_update_2_x_to_3_0($dbh,$options);

				$post_install_error .= do_delta_update_3_0_to_3_2($dbh);

				$post_install_error .= do_delta_update_3_2_to_3_3($dbh,$options);

				$post_install_error .= do_delta_update_3_3_to_3_4($dbh);

				$post_install_error .= do_delta_update_3_4_to_3_5($dbh);

				$post_install_error .= do_delta_update_3_5_to_4_0_beta($dbh);

				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version === '3.0' || $current_machform_version === '3.1'){ 
				//if we're upgrading from v3.0 or v3.1

				$post_install_error .= do_delta_update_3_0_to_3_2($dbh);

				$post_install_error .= do_delta_update_3_2_to_3_3($dbh);

				$post_install_error .= do_delta_update_3_3_to_3_4($dbh);

				$post_install_error .= do_delta_update_3_4_to_3_5($dbh);

				$post_install_error .= do_delta_update_3_5_to_4_0_beta($dbh);

				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version === '3.2'){
				//if we're upgrading from v3.2
				$post_install_error .= do_delta_update_3_2_to_3_3($dbh);

				$post_install_error .= do_delta_update_3_3_to_3_4($dbh);

				$post_install_error .= do_delta_update_3_4_to_3_5($dbh);

				$post_install_error .= do_delta_update_3_5_to_4_0_beta($dbh);

				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version === '3.3'){
				//if we're upgrading from v3.3
				$post_install_error .= do_delta_update_3_3_to_3_4($dbh);

				$post_install_error .= do_delta_update_3_4_to_3_5($dbh);

				$post_install_error .= do_delta_update_3_5_to_4_0_beta($dbh);

				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version === '3.4'){
				//if we're upgrading from v3.4				
				$post_install_error .= do_delta_update_3_4_to_3_5($dbh);

				$post_install_error .= do_delta_update_3_5_to_4_0_beta($dbh);

				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version === '3.5'){
				//if we're upgrading from v3.5				
				$post_install_error .= do_delta_update_3_5_to_4_0_beta($dbh);

				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version == '4.0.beta'){
				//if we're upgrading from v4.0.beta				
				$post_install_error .= do_delta_update_4_0_beta_to_4_0($dbh);

				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version == '4.0'){
				//if we're upgrading from v4.0				
				$post_install_error .= do_delta_update_4_0_to_4_1($dbh);

				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}else if($current_machform_version == '4.1'){
				//if we're upgrading from v4.1				
				$post_install_error .= do_delta_update_4_1_to_4_2($dbh);
			}	

			//repopulate ap_fonts content with updated data
			$post_install_error .= populate_ap_fonts_table($dbh);

			if(empty($post_install_error)){
				$installation_success = true;

				//update ap_settings table with the latest version
				$settings['machform_version'] = NEW_MACHFORM_VERSION;
				mf_ap_settings_update($settings,$dbh);

				//clear the session, so that the user need to re-login
				$_SESSION = array();
			}else{
				$installation_has_error = true;
			}

		} //end !is_invalid_admin_email & !is_invalid_license_key
	}//end run_upgrade

	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>ارتقاء اسکریپت فرمساز</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="robots" content="index, nofollow" />
<link rel="stylesheet" type="text/css" href="css/main.css" media="screen" />   
    
<!--[if IE 7]>
	<link rel="stylesheet" type="text/css" href="css/ie7.css" media="screen" />
<![endif]-->
	
<!--[if IE 8]>
	<link rel="stylesheet" type="text/css" href="css/ie8.css" media="screen" />
<![endif]-->

<!--[if IE 9]>
	<link rel="stylesheet" type="text/css" href="css/ie9.css" media="screen" />
<![endif]-->
   
<link href="css/theme.css" rel="stylesheet" type="text/css" />
<link href="css/bb_buttons.css" rel="stylesheet" type="text/css" />
<link type="text/css" href="js/jquery-ui/themes/base/jquery.ui.all.css" rel="stylesheet" />
<link type="text/css" href="css/edit_form.css" rel="stylesheet" />
<link type="text/css" href="js/datepick/smoothness.datepick.css" rel="stylesheet" />
<link href="css/override.css" rel="stylesheet" type="text/css" />
<style>
	#submit_button{
		border-radius: 4px !important;
	}
</style>
</head>

<body>

<div id="bg" class="installer_page">

<div id="container">

	<div id="header">
	
		<div id="logo">
			<img class="title" src="images/machform_logo.png" style="margin-left: 8px" alt="MachForm" />
		</div>	

		
		<div class="clear"></div>
		
	</div>
	<div id="main">
	
 
		<div id="content">
			<div class="post installer">

				<div style="padding-top: 10px">
					
					<?php if(empty($pre_install_error)){ ?>

					<?php 	if($installation_success && ($current_machform_version === '2')){ ?>
								<div>
									<img src="images/icons/62_green_48.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>موفقیت آمیز!</h3>
									<p>ارتقاء سازی فرمساز شما تکمیل گردید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="index.php">
										<ul>
											<li>
												<p>برای ورود در زیر اطلاعات فرمساز خود را وارد کنید:</p>
												<p style="margin-top: 10px; margin-bottom: 20px">ایمیل: <b><?php echo htmlspecialchars($admin_username); ?></b><br/>
												   کلمه عبور: <b>machform</b></p>
												<p>لطفا پس از ورود پسور خود را تغییر بدهید!</a>
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-keyhole"></span>
											        ورود به فرمساز
											    </button>
											</li>
										</ul>
									</form>
								</div>
					<?php 	}else if($installation_success && ($current_machform_version !== '2')){ ?>
								<div>
									<img src="images/icons/62_green_48.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>موفقیت آمیز!</h3>
									<p>ارتقاء سازی فرمساز شما تکمیل گردید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="index.php">
										<ul>
											<li>
												<h5 style="font-size: 16px;font-weight: 400;color: #529214">فرمساز شما ارتقاء یافته به ورژن <strong><?php echo NEW_MACHFORM_VERSION; ?></strong></h5>
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-keyhole"></span>
											        ورود به فرمساز
											    </button>
											</li>
										</ul>
									</form>
								</div>	
					<?php	}else if($installation_has_error){ //if server meet the requirements but error during install (error while creating tables) ?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا در هنگام ارتقا!</h3>
									<p>لطفا خطای زیر را اصلاح کنید و دوباره سعی کنید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5><?php echo $post_install_error; ?></h5>	
											</li>
											<li>
لطفاً مطمئن شوید که کاربر پایگاه داده سطح دسترسی برای ایجاد و تغییر جداول را دارد											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-checkmark"></span> 
											        تلاش دوباره
											    </button>
											</li>
										</ul>
									</form>
								</div>
					
					<?php   }else if($quick_upgrade === true){ ?>
								<div>
									<img src="images/icons/advancedsettings.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>فرمساز آماده ارتقاء</h3>
									<p>کلیک کنید بر روی دکمه ارتقاء برای ادامه.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">
										<ul>
											<li style="margin-bottom: 5px;margin-top: 20px;">
												<h5 style="font-size: 16px;font-weight: 400;color: #529214">لازم است که قبل از ارتقاء از فرمساز خود یک نسخه پشتیبان تهیه نمایید</h5>
											</li>		
								    		<li id="li_submit" class="buttons" style="overflow: auto">
								    			<input type="hidden" name="run_upgrade" id="run_upgrade" value="1">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-checkmark"></span>
											        ارتقاء به فرمساز <?php echo NEW_MACHFORM_VERSION; ?>
											    </button>
											</li>
										</ul>
									</form>
								</div>	

					<?php   }else{ ?>
								<div>
									<img src="images/icons/advancedsettings.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>فرمساز آماده به ارتقاء</h3>
									<p>لطفاء فرم زیر را پر کنید و بر روی دکمه ارتقاء کلیک کنید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">
										<ul>
											<?php if($is_invalid_admin_email){ ?>
												<li id="li_installer_notification">
													<h5>خطا! لطفا آدرس ایمیل معتبر وارد کنید!</h5>
												</li>
											<?php }else if($is_invalid_license_key){ ?>
												<li id="li_installer_notification">
													<h5>خطا! لطفا شماره مجوز معتبر وارد کنید!</h5>
												</li>
											<?php } ?>

											<li id="li_email_address" style="margin-top: 25px;">		
												<label class="desc" for="admin_username">آدرس ایمیلتان</label>
												<div>
													<input id="admin_username" name="admin_username" class="element text large" type="text" maxlength="255" value="<?php echo htmlspecialchars($admin_username); ?>"/>
													<span style="font-size: 85%;color: #444444">شما از این استفاده خواهید کرد برای ورود به پنل مدیریت</span> 
												</div>
											</li>
											<li id="li_license_key">		
												<label class="desc" for="license_key">شماره مجوز</label>
												<div>
													<input id="license_key" name="license_key" class="element text large" type="text" maxlength="255" value="<?php echo htmlspecialchars($license_key); ?>"/> 
												</div>
											</li>
											<li style="margin-bottom: 5px">
												<h5 style="font-size: 16px;font-weight: 400;color: #529214">لازم است قبل از ارتقاء از پایگاه داده ها یک نسخه پشتیبان تهیه نمایید</h5>
											</li>		
								    		<li id="li_submit" class="buttons" style="overflow: auto">
								    			<input type="hidden" name="run_upgrade" id="run_upgrade" value="1">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-checkmark"></span>
											        ارتقاء فرمساز <?php echo NEW_MACHFORM_VERSION; ?>
											    </button>
											</li>
										</ul>
									</form>
								</div>	

					<?php   }
								
						
						 }else{ //else if there are pre install error 
							if($pre_install_error == 'php_version_insufficient' || $pre_install_error == 'data_dir_unwritable'){
								if($pre_install_error == 'php_version_insufficient'){
									$pre_install_error = "نسخه PHP فعلی شما (".PHP_VERSION.") کمتر از حداقل مورد نیاز است (5.2.0)";
								}else{
									$pre_install_error = "پوشه <strong><u>data</u></strong> درون فولدر فرمساز شما قابل نوشتن نیست. لطفاً قرار دهید حق دسترسی قابل نوشتن را روی (CHMOD 777)";
								}
					?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا! سیستم قادر به نصب نیست</h3>
									<p>لطفاً خطا را رفع و کلیک کنید برای ادامه دادن</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5><?php echo $pre_install_error; ?></h5>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-checkmark"></span>
											        بررسی دوباره
											    </button>
											</li>
										</ul>
									</form>
								</div>	
					<?php	}else if($pre_install_error == 'machform_already_installed'){ ?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>فرمساز در حال حاضر ارتقاء یافته</h3>
									<p>لطفاً از زیر وارد پنل مدیریت شوید.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="index.php">
										<ul>
											<li id="li_installer_notification">
												<h5>در حال حاضر بروز هستید! (v<?php echo NEW_MACHFORM_VERSION ?>).</h5><h5>شما می توانید به پنل مدیریت وارد شوید برای ایجاد / ویرایش فرمهایتان.</h5>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-keyhole"></span>
											        ورود به فرمساز
											    </button>
											</li>
										</ul>
									</form>
								</div>	

					<?php	}else if($pre_install_error == 'machform_db_not_exist'){ ?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا! فرمساز یافت نشد</h3>
									<p>لطفاً خطا را رفع و کلیک کنید برای ادامه دادن.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5>به منظور ارتقا به ورژن 3 <br />شما نیاز به نصب نسخه های 2 دارید.</h5><br /><h5>نیاز دارید به بازبینی config.php <br />در فایل هیچ خطا و تایپی.</h5><br/><h5>اگر شما برای اولین بار است که از فرمساز استفاده می کنید, <br/>از آن پس بجای <a href="installer.php" style="color: blue;text-decoration: underline"> صفحه نصب</a> بروید.</h5>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-checkmark"></span>
											        بررسی دوباره
											    </button>
											</li>
										</ul>
									</form>
								</div>	
					<?php	}else if($pre_install_error == 'version1_incompatible'){ ?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا! سیستم قادر به ارتقاء نیست</h3>
									<p>لطفاً خطا را رفع و کلیک کنید برای ادامه دادن.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5>به منظور ارتقاء به نسخه 4, <br />شما نیاز به نصب حداقل نسخه های 2 می باشید.</h5><br /><h5>به نظر می رسد که شما نسخه 1 را نصب کرده اید.</h5><br/><h5>شما ابتدا نیاز به نصب نسخه های 2 را دارید.</h5>	
											</li>
										</ul>
									</form>
								</div>

					<?php	}else{  ?>
								<div>
									<img src="images/icons/warning.png" align="absmiddle" style="width: 48px; height: 48px;float: left;padding-right: 10px;padding-top: 10px"/>
									<h3>خطا در اتصال به پایگاه داده</h3>
									<p>لطفاً خطا را رفع و کلیک کنید برای ادامه دادن.</p>
									<div style="clear:both; border-bottom: 1px dotted #CCCCCC;margin-top: 15px"></div>
								</div>
								
								<div style="margin-top: 10px;margin-bottom: 10px">
									<form id="form_installer" class="appnitro"  method="post" action="">
										<ul>
											<li id="li_installer_notification">
												<h5><?php echo $pre_install_error; ?></h5>
											</li>
											<li style="font-family: Arial, Helvetica, sans-serif">
												<p>چند چیز هست که شما می توانید برای رفع مشکل سعی کنید:
													<ul style="list-style-type:disc;">
														<li style="margin-left: 20px;padding-left: 0px;padding-bottom: 0px">اطمینان حاصل کنید که نام کاربری پایگاه داده و رمز عبور درست است</li>
														<li style="margin-left: 20px;padding-left: 0px">مطمئن شوید که نام میزبان پایگاه داده صحیح است</li>
													</ul>
												</p>
												<p style="margin-top: 15px">اگر مشکل ادامه داشت، لطفاً <a style="text-decoration: underlin" href="http://www.appnitro.com/support/index.php?pg=request" target="_blank">با ما تماس داشته باشید</a> و ما خوشحال خواهیم شد که بتوانیم کمکتان کنیم!</p>	
											</li>
								    		<li id="li_submit" class="buttons" style="overflow: auto">
										    	<button type="submit" class="bb_button bb_green" id="submit_button" name="submit_button" style="float: left">
											        <span class="icon-checkmark"></span>
											        بررسی دوباره
											    </button>
											</li>
										</ul>
									</form>
								</div>	


					<?php	}	
 						  } //end - else if there are pre install error
					?>
					
					
				</div>
     
        	</div>  		 
		</div>
	
		

<?php
	$footer_data =<<<EOT
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.core.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.widget.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.tabs.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.mouse.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.sortable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.draggable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.position.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.dialog.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.effects.core.js"></script>
EOT;
	require('includes/footer.php'); 
?>
